/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.vues.ecrans.saisie;

import fr.asip.cps3.exemple.modele.objets.Objet;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie;
import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SaisieObjet
extends Saisie {
    protected long idObjet = -1L;
    protected JLabel libelleObjet;
    protected JTextField texteLibelleObjet;
    protected JLabel libelleObjetDonnees;
    protected JTextArea texteObjet;
    protected JScrollPane scrollObjet;

    public SaisieObjet(FenetrePrincipale fenetrePrincipale, int n) {
        this(fenetrePrincipale, n, null);
    }

    public SaisieObjet(FenetrePrincipale fenetrePrincipale, int n, Objet objet) {
        super(fenetrePrincipale, n);
        if (n == 12) {
            this.libelleObjet = new JLabel("Entrez un libell\u00e9 pour l'objet :");
            this.libelleObjetDonnees = new JLabel("Entrez l'objet sous forme h\u00e9xad\u00e9cimale :");
            this.texteLibelleObjet = new JTextField();
            this.texteObjet = new JTextArea();
        } else if (n == 13) {
            this.libelleObjet = new JLabel("Libell\u00e9 de l'objet :");
            this.libelleObjetDonnees = new JLabel("Modifier la valeur de l'objet (sous forme h\u00e9xad\u00e9cimale) :");
            if (objet != null) {
                this.idObjet = objet.getIdObjet();
                if (objet.getLibelle() != null) {
                    this.texteLibelleObjet = new JTextField(objet.getLibelle());
                }
                if (objet.getValeur() != null) {
                    this.texteObjet = new JTextArea(objet.getValeur());
                }
            }
            this.texteLibelleObjet.setEditable(false);
        }
        this.texteObjet.setLineWrap(true);
        this.texteObjet.setWrapStyleWord(true);
        this.scrollObjet = new JScrollPane(this.texteObjet, 20, 30);
        this.scrollObjet.setBackground(Color.white);
    }

    public long getIdObjet() {
        return this.idObjet;
    }

    public String getObjet() {
        return this.texteObjet.getText();
    }

    public String getLibelleObjet() {
        return this.texteLibelleObjet.getText();
    }

    public void affiche() {
        JFrame jFrame = this.fenetre.getFenetre();
        if (jFrame != null && jFrame.getContentPane() != null) {
            EcranUtil.supprimeTousLesComposants((JPanel)jFrame.getContentPane());
            ((JPanel)jFrame.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
            GridBagLayout gridBagLayout = new GridBagLayout();
            ((JPanel)jFrame.getContentPane()).setLayout(gridBagLayout);
            GridBagHelper gridBagHelper = new GridBagHelper(jFrame.getContentPane());
            gridBagHelper.ajoute(this.libelleObjet, EcranUtil.styleLibelleSaisieObjet, 0, 0, 1, 1);
            gridBagHelper.ajoute(this.texteLibelleObjet, EcranUtil.styleChampTexteLibelleObjet, 0, 1, 1, 1);
            gridBagHelper.ajoute(this.libelleObjetDonnees, EcranUtil.styleLibelleSaisieObjet, 1, 0, 1, 1);
            gridBagHelper.ajoute(this.scrollObjet, EcranUtil.styleScrollSaisieObjet, 1, 1, 1, 1);
            gridBagHelper.ajoute(this.soumettre, EcranUtil.styleBoutonSoumettre, 2, 0, 1, 2);
            gridBagHelper.ajoute(this.barreStatut, EcranUtil.styleBarreStatut, 3, 0, 1, 2);
        }
    }
}

